<?php
/*
=====================================================
 DleMovie (Module for CMS DataLife Engine)
-----------------------------------------------------
 Copyright (c) 2011, 2012 Alexander Ahminenko
=====================================================
     
-----------------------------------------------------
 E-Mail, ICQ: a.ahminenko@gmail.com, 681216
=====================================================
*/
if ( ! defined ( 'DATALIFEENGINE' ) ) {
	die( 'Hacking attempt!' );
}
if ( file_exists( ROOT_DIR . '/language/' . $config['langs'] . '/dlemovie.lng' ) ) {
    include ROOT_DIR . '/language/' . $config['langs'] . '/dlemovie.lng';
} elseif ( file_exists( ROOT_DIR . '/language/Russian/dlemovie.lng' ) ) {
     include ROOT_DIR . '/language/Russian/dlemovie.lng';
}
if ( ! class_exists( 'DleMovie' ) ) {
class DleMovie {
    public $db = false;
	public $lang = array( );
    public $config = array( );
	public $dleconfig = array( );
	public $category = false;
	public $isadmin = false;
	public $providers = array(
			'youtube' => 'YouTube',
			'rutube' => 'RuTube',
			'vimeo' => 'Vimeo',
			'redtube' => 'RedTube',
			'vkontakte' => '',
			'kiwi' => 'Kiwi',
			'smotri' => 'Smotri',
			'dailymotion' => 'DailyMotion',
			'lovitv' => 'LoviTV',
	);
	
	public $version = '1.4';
	public $build = '00001111';
	
	private $screenw = 200;
	private $screenh = 140;
	private $metatags = array( );
    
	public function __construct( $db, $config, $dleconfig, $isadmin = false ) {
		$this->db = $db;
		$this->config = $config;
		$this->dleconfig = $dleconfig;
		$this->isadmin = $isadmin;
		$this->licenseCheck( );
		return true;
	}
	public function parseUrl( $normal, $short ) {
		if ( $this->dleconfig['allow_alt_url'] == 'yes' ) return $this->dleconfig['http_home_url'] . $short;
		return $this->dleconfig['http_home_url'] . $normal;
	}
	public function parseUrlPage( $links, $page ) {
		return str_replace( '{page}', $page, $this->parseUrl( $links['normal'], $links['short'] ) );
	}
	public function metatagBuild( ) {
		$i = 0;
		$result = '';
		if ( is_array( $this->metatags ) and count( $this->metatags ) > 0 ) {
			foreach ( $this->metatags as $text ) {
				if ( $i > 0 ) $result .= ' &raquo; ' . $text;
				else $result .= $text;
				$i ++;
			}
		}
		return $result;
	}
	public function metatagAdd( $data ) {
		if ( is_array( $data ) and count( $data ) > 0 ) {
			foreach ( $data as $string ) $this->metatags[] = $string;
		} else $this->metatags[] = $data;
		return true;
	}
	public function infoBox( $text, $is_error = false ) {
		$csstype = $is_error ? 'dlemovie-notice-error' : 'dlemovie-notice-normal';
		return '<div class="' . $csstype . '">' . $text . '</div>';
	}
	public function incCssAndJs( $_css = false, $_js = false ) {
		if ( $_REQUEST['__dlemovie_incjs'] == 'yes' ) return '';
		$js = '<script type="text/javascript" src="' . $this->dleconfig['http_home_url'] . 'engine/modules/dlemovie/interface/functions.js"></script>';
		$css = '<link type="text/css" rel="stylesheet" href="{THEME}/dlemovie/css/main.css" />';
		if ( $_css and $_js ) return $css . $js;
		elseif ( $_css ) return $css;
		elseif ( $_js ) return $js;
		else return '';
	}
	public function makeSelectOptions( $options, $selected = false ) {
		$result = '';
		foreach ( $options as $key => $value ) {
			if ( $key == $selected ) $result .= '<option value="' . $key . '" selected>' . $value . '</option>';
			else $result .= '<option value="' . $key . '">' . $value . '</option>';
		}
		return $result;
	}
	public function categoryInfo( $id ) {
		$info = array( );
		if ( $id > 0 ) {
			$info['title'] = $this->category[$id]['title'];
			$info['link'] = $this->parseUrl( '?do=video&act=category&name=' . $this->category[$id]['name'], 'video/' . $this->category[$id]['name'] . '/' );
			$info['name'] = $this->category[$id]['name'];
		} else {
			$info['title'] = $this->lang['not_category_short'];
			$info['link'] = $this->parseUrl( '?do=video&view=all', 'video/all/' );
			$info['name'] = 'all';
		}
		return $info;
	}
	public function playTime( $sec ) {
		if ( $sec > 0 ) {
			$h = floor( $sec / 3600 );
			$m = $h > 0 ? floor( ( $sec - ( $h * 3600 ) ) / 60 ) : floor( $sec / 60 );
			$s = floor( $sec % 60 );
			$h = dle_strlen( $h, $this->dleconfig['charset'] ) == 1 ? '0' . $h : $h;
			$m = dle_strlen( $m, $this->dleconfig['charset'] ) == 1 ? '0' . $m : $m;
			$s = dle_strlen( $s, $this->dleconfig['charset'] ) == 1 ? '0' . $s : $s;
			if ( $h != '0' and $h != '00' ) return $h . ':' . $m . ':' . $s;
			return $m . ':' . $s;
		} else return '-';
	}
	public function curlQuery( $location, $params = array( ), $method = 'POST', $cookies = array( ), $headers = array( ), &$response = false ) {
		$is_post = ( strtoupper( $method ) == 'POST' ) ? true : false;
		if ( count( $params ) > 0 ) {
			$data = ( substr_count( $location, '?' ) > 0 ) ? '&' : '?';
			foreach ( $params as $key => $value ) $data .= urlencode( $key ) . '=' . urlencode( $value ) . '&';
			$data = dle_substr( $data, 0, dle_strlen( $data, $this->dleconfig['charset'] ) - 1, $this->dleconfig['charset'] );
		} else $data = '';
		$main = $is_post ? curl_init( $location ) : curl_init( $location . $data );
		if ( substr_count( $location, 'https' ) > 0 ) {
			curl_setopt( $main, CURLOPT_SSL_VERIFYPEER, false );
			curl_setopt( $main, CURLOPT_SSL_VERIFYHOST, false );
		}
		curl_setopt( $main, CURLOPT_HEADER, false );
		if ( $is_post ) {
			curl_setopt( $main, CURLOPT_POST, true );
			curl_setopt( $main, CURLOPT_POSTFIELDS, $data );
		} else curl_setopt( $main, CURLOPT_POST, false );
		if ( count( $headers ) > 0 ) {
			$datahead = array( );
			foreach ( $headers as $key => $value ) $datahead[] = $key . ': ' . $value;
			curl_setopt( $main, CURLOPT_HTTPHEADER, $datahead );
		}
		if ( count( $cookies ) > 0 ) {
			$datacook = '';
			foreach ( $cookies as $key => $value ) $datacook .= $key . '=' . urlencode( $value ) . '; ';
			curl_setopt( $main, CURLOPT_COOKIE, dle_substr( $datacook, 0, dle_strlen( $datacook, $this->dleconfig['charset'] ) - 2, $this->dleconfig['charset'] ) );
		}
		curl_setopt( $main, CURLOPT_RETURNTRANSFER, true );
		curl_setopt( $main, CURLOPT_TIMEOUT, 30 );
		$response = curl_exec( $main );
		$status = curl_errno( $main ) ? false : true;
		curl_close( $main );
		return $status;
	}
	public function videoImport( $video, $provider ) {
		$domain = trim( str_replace( 'www.', '', $_SERVER['HTTP_HOST'] ) );
		$length = dle_strlen( $domain, $this->dleconfig['charset'] );
		$domain = ( $domain{$length-1} == '.' ) ? dle_substr( $domain, 0, $length - 1, $this->dleconfig['charset'] ) : $domain;
		$params = array( 'license' => $this->config['license_key'], 'domain' => $domain, 'version' => $this->version, 'build' => $this->build, 'provider' => $provider, 'video' => $video );
		if ( $provider == 'vkontakte' ) $params = array_merge( $params, array( 'limit[1]' => ( ( $this->config['youtube_allow'] == 'yes' ) ? 'allow' : 'not' ), 'limit[2]' => ( ( $this->config['vimeo_allow'] == 'yes' ) ? 'allow' : 'not' ) ) );
		$this->curlQuery( 'http://server.focusweb.ru/dlemovie/import/', $params, 'GET', array( ), array( ), $response );
		if ( strtolower( $this->dleconfig['charset'] ) == 'utf-8' ) $response = iconv( 'WINDOWS-1251', 'UTF-8', $response );
		$array = unserialize( $response );
		if ( empty( $response ) or ! is_array( $array ) or count( $array ) < 1 ) return false;
		return $array;
	}
	public function isFileUrl( $url, $types = array( ) ) {
		if ( count( $types ) <= 0 ) return preg_match_all( '#(http|ftp)://([A-Za-z0-9_.@:]+)/(.*)#i', $url );
		elseif ( preg_match_all( '#(http|ftp)://([A-Za-z0-9_.@:]+)/(.*)#i', $url ) and in_array( end( explode( '.', $url ) ), $types ) ) return false;
		return false;
	}
	public function isVideoUrl( $url, &$data = array( ) ) {
		if ( substr_count( $url, 'youtu' ) > 0 ) {
			if ( $this->config['youtube_allow'] != 'yes' ) return false;
			$preg1 = preg_match_all( '#youtube.com(.*)v=([A-Z0-9-_]+)#is', $url, $matches1 );
			$preg2 = preg_match_all( '#youtu.be/([A-Z0-9-_]+)#is', $url, $matches2 );
			if ( $preg1 or $preg2 ) {
				$data = array( 'provider' => 'youtube', 'videoid' => ( $preg1 ? $matches1[2][0] : $matches2[1][0] ) );
				return true;
			}
		} else if ( substr_count( $url, 'rutube' ) > 0 ) {
			if ( $this->config['rutube_allow'] != 'yes' ) return false;
			$preg = preg_match_all( '#rutube.ru/tracks/([0-9]+).html#is', $url, $matches );
			if ( $preg ) {
				$data = array( 'provider' => 'rutube', 'videoid' => $matches[1][0] );
				return true;
			}
		} else if ( substr_count( $url, 'vimeo' ) > 0 ) {
			if ( $this->config['vimeo_allow'] != 'yes' ) return false;
			$preg = preg_match_all( '#vimeo.com/([0-9]+)#is', $url, $matches );
			if ( $preg ) {
				$data = array( 'provider' => 'vimeo', 'videoid' => $matches[1][0] );
				return true;
			}
		} else if ( substr_count( $url, 'vk.com' ) > 0 ) {
			if ( $this->config['vkontakte_allow'] != 'yes' ) return false;
			$preg_member = preg_match_all( '#vk.com/video([0-9]+)_([0-9]+)#is', $url, $matches_member );
			$preg_group = preg_match_all( '#vk.com/video-([0-9]+)_([0-9]+)#is', $url, $matches_group );
			if ( $preg_member or $preg_group ) {
				$vkid = $preg_member ? $matches_member[1][0] : $matches_group[1][0];
				$vkhash = $preg_member ? $matches_member[2][0] : $matches_group[2][0];
				$data = array( 'provider' => 'vkontakte', 'videoid' => ( $preg_member ? 'm' : 'g' ) . ',' . $vkid . ',' . $vkhash );
				return true;
			}
		} else if ( substr_count( $url, 'redtube' ) > 0 ) {
			if ( $this->config['redtube_allow'] != 'yes' ) return false;
			$preg = preg_match_all( '#redtube.com/([0-9]+)#is', $url, $matches );
			if ( $preg ) {
				$data = array( 'provider' => 'redtube', 'videoid' => $matches[1][0] );
				return true;
			}
		} else if ( substr_count( $url, 'kiwi' ) > 0 ) {
			if ( $this->config['kiwi_allow'] != 'yes' ) return false;
			$preg = preg_match_all( '#kiwi.kz/watch/([A-Z0-9-_]+)#is', $url, $matches );
			if ( $preg ) {
				$data = array( 'provider' => 'kiwi', 'videoid' => $matches[1][0] );
				return true;
			}
		} else if ( substr_count( $url, 'smotri' ) > 0 ) {
			if ( $this->config['smotri_allow'] != 'yes' ) return false;
			$preg = preg_match_all( '#smotri.com/video/view/\?id=([A-Z0-9]+)#is', $url, $matches );
			if ( $preg ) {
				$data = array( 'provider' => 'smotri', 'videoid' => $matches[1][0] );
				return true;
			}
		} else if ( substr_count( $url, 'dailymotion' ) > 0 ) {
			if ( $this->config['dailymotion_allow'] != 'yes' ) return false;
			$preg = preg_match_all( '#dailymotion.com/video/([^_]+)#is', $url, $matches );
			if ( $preg ) {
				$data = array( 'provider' => 'dailymotion', 'videoid' => $matches[1][0] );
				return true;
			}
		} else if ( substr_count( $url, 'lovi.tv' ) > 0 ) {
			if ( $this->config['lovitv_allow'] != 'yes' ) return false;
			$preg = preg_match_all( '#lovi.tv/video/([A-Z0-9-_./]+)#is', $url, $matches );
			if ( $preg ) {
				$data = array( 'provider' => 'lovitv', 'videoid' => $matches[1][0] );
				return true;
			}
		} else return false;
		return false;
	}
	public function playerShow( $videoid, $provider, $height = false ) {
		$height = ( $height <= 0 ) ? 360 : $height;
		if ( $provider == 'youtube' ) {
			if ( $this->config['youtube_player'] != 'standart' ) return $this->playerShowJw( 'http://www.youtube.com/watch?v=' . $videoid, $height );
			else return '<iframe width="100%" height="' . $height . '" src="http://www.youtube.com/embed/' . $videoid . '" frameborder="0" allowfullscreen></iframe>';
		} elseif ( $provider == 'rutube' ) {
			$url = 'http://video.rutube.ru/' . $videoid;
			return '<object width="100%" height="' . $height . '">
					<param name="movie" value="' . $url . '"></param>
					<param name="wmode" value="window"></param>
					<param name="allowFullScreen" value="true"></param>
					<embed src="' . $url . '" type="application/x-shockwave-flash" wmode="window" width="100%" height="' . $height . '" allowFullScreen="true" ></embed>
					</object>';
		} elseif ( $provider == 'vimeo' ) {
			return '<iframe src="http://player.vimeo.com/video/' . $videoid . '" width="100%" height="' . $height . '" frameborder="0" webkitAllowFullScreen allowFullScreen></iframe>';
		} elseif ( $provider == 'vkontakte' ) {
			list( $vkuser, $vkvideo, $vkhash ) = explode( ',', $videoid );
			return '<iframe src="http://vkontakte.ru/video_ext.php?oid=' . $vkuser . '&id=' . $vkvideo . '&hash=' . $vkhash . '" width="100%" height="' . $height . '" frameborder="0"></iframe>';
		} elseif ( $provider == 'redtube' ) {
			return '<object height="' . $height . '" width="100%">
					<param name="movie" value="http://embed.redtube.com/player/">
					<param name="allowFullScreen" value="true"></param>
					<param name="FlashVars" value="id=' . $videoid . '&style=redtube&autostart=false">
					<embed src="http://embed.redtube.com/player/?id=' . $videoid . '&style=redtube" flashvars="autostart=false" pluginspage="http://www.adobe.com/shockwave/download/download.cgi?P1_Prod_Version=ShockwaveFlash" type="application/x-shockwave-flash" height="' . $height . '" width="100%" allowFullScreen="true" />
					</object>';
		} elseif ( $provider == 'kiwi' ) {
			return '<object width="100%" height="' . $height . '">
					<param name="movie" value="http://v.kiwi.kz/v/' . $videoid . '/"></param>
					<param name="allowFullScreen" value="true"></param>
					<param name="allowScriptAccess" value="always"></param>
					<embed src="http://v.kiwi.kz/v/' . $videoid . '/" type="application/x-shockwave-flash" width="100%" height="' . $height . '" allowFullScreen="true" allowScriptAccess="always"></embed>
					</object>';
		} elseif ( $provider == 'smotri' ) {
			return $this->playerShowJw( $videoid, $height );
		} elseif ( $provider == 'dailymotion' ) {
			return '<iframe frameborder="0" width="100%" height="' . $height . '" src="http://www.dailymotion.com/embed/video/' . $videoid . '?logo=0"></iframe>';
		} elseif ( $provider == 'lovitv' ) {
			return '<iframe width="470" height="' . $height . '" src="http://lovi.tv/video/sharer.php?Code=' . $videoid . '&Width=470&Height=' . $height . '" frameborder="0" allowfullscreen></iframe>';
		} else return '';
	}
	private function playerShowJw( $url, $height ) {
		$jwskin = str_replace( 'jw-', '', $this->config['youtube_player'] ) . '.zip';
		if ( ! empty( $jwskin ) and @file_exists( ENGINE_DIR . '/modules/dlemovie/interface/media/jwplayer/' . $jwskin ) ) $jwskin = ',skin:"' . $this->dleconfig['http_home_url'] . 'engine/modules/dlemovie/interface/media/jwplayer/' . $jwskin . '"';
		return '<div id="dlemovie-player">Please update your Adobe Flash Player.</div><script type="text/javascript" src="' . $this->dleconfig['http_home_url'] . 'engine/modules/dlemovie/interface/media/jwplayer/jwplayer.js"></script>
				<script type="text/javascript">jwplayer("dlemovie-player").setup({flashplayer:"' . $this->dleconfig['http_home_url'] . 'engine/modules/dlemovie/interface/media/jwplayer/jwplayer.swf",file:"' . $url . '",width:"auto",height:' . $height . ',controlbar:"bottom"' . $jwskin . ',stretching:"fill"});</script>';
	}
	public function screenResize( $in, $out, $sizes ) {
		list( $in_w, $in_h ) = getimagesize( $in );
		if ( is_array( $sizes ) and count( $sizes ) > 0 ) {
			$out_w = $sizes[0];
			$out_h = $sizes[1];
		} else {
			if ( $sizes <= 0 ) $sizes = 0.5;
			$out_w = $in_w * $sizes;
			$out_h = $in_h * $sizes;
		}
		$format = strtolower( end( explode( '.', $in ) ) );
		if ( $format == 'jpg' or $format == 'jpeg' ) $image = imagecreatefromjpeg( $in );
		elseif ( $format == 'png' ) $image = imagecreatefrompng( $in );
		elseif ( $format == 'gif' ) $image = imagecreatefromgif( $in );
		$output = imagecreatetruecolor( $out_w, $out_h );
		if ( $format == 'png' ) {
			imagealphablending( $output, false );
			imagesavealpha( $output, true );
		}
		imagecopyresized( $output, $image, 0, 0, 0, 0, $out_w, $out_h, $in_w, $in_h );
		if ( $format == 'jpg' or $format == 'jpeg' ) imagejpeg( $output, $out, 100 );
		elseif ( $format == 'png' ) imagepng( $output, $out );
		elseif ( $format == 'gif' ) imagegif( $output, $out );
		imagedestroy( $output );
		return true;
	}
	public function screenCrop( $in, $out, $sizes ) {
		list( $width, $height ) = getimagesize( $in );
		list( $widthnew, $heightnew ) = $sizes;
		$format = strtolower( end( explode( '.', $in ) ) );
		if ( $format == 'jpg' or $format == 'jpeg' ) $image = imagecreatefromjpeg( $in );
		elseif ( $format == 'png' ) $image = imagecreatefrompng( $in );
		elseif ( $format == 'gif' ) $image = imagecreatefromgif( $in );
		$output = imagecreatetruecolor( $widthnew, $heightnew );
		if ( $format == 'png' ) {
			imagealphablending( $output, false );
			imagesavealpha( $output, true );
		}
		$coordx = $widthnew / 2;
		$coordy = $heightnew / 2 + 3;
		$width = $widthnew + $coordx;
		$height = $heightnew + $coordy;
		imagecopyresampled( $output, $image, 0, 0, $coordx, $coordy, $widthnew, $heightnew, $width, $height );
		if ( $format == 'jpg' or $format == 'jpeg' ) imagejpeg( $output, $out, 100 );
		elseif ( $format == 'png' ) imagepng( $output, $out );
		elseif ( $format == 'gif' ) imagegif( $output, $out );
		imagedestroy( $output );
		return true;
	}
	public function screenSave( $url, $width = false ) {
		$width = ( intval( $width ) > 0 ) ? intval( $width ) : false;
		$type = strtolower( end( explode( '.', $url ) ) );
		$screen = @file_get_contents( $url );
		$filename = md5( microtime( ) ) . '.' . $type;
		$fullname = ROOT_DIR . '/uploads/dlemovie/' . $filename;
		if ( ! $screen or empty( $type ) ) return '';
		$save = @fopen( $fullname, 'w+b' );
		if ( ! $save ) return '';
		@fwrite( $save, $screen );
		@fclose( $save );
		if ( ! $width ) {
			$width = getimagesize( $fullname );
			$width = $width[0];
		}
		if ( $width >= $this->screenw * 2 ) $this->screenCrop( $fullname, $fullname, array( $this->screenw, $this->screenh ) );
		else if ( $width > $this->screenw ) $this->screenResize( $fullname, $fullname, round( $this->screenw / $width, 5 ) );
		return $filename;
	}
	public function cacheClear( $cachename = false, $onlysize = false ) {
		$size = 0;
		$caches = array( 'category' => 'system/dlemovie-category.php' );
		if ( $cachename === false ) {
			foreach ( $caches as $file ) {
				if ( ! $onlysize ) @unlink( ENGINE_DIR . '/cache/' . $file );
				else $size += @filesize( ENGINE_DIR . '/cache/' . $file );
			}
			$temporary = @opendir( ENGINE_DIR . '/cache/' );
			while ( $file = @readdir( $temporary ) ) {
				if ( substr_count( $file, 'dlemovie' ) > 0 ) {
					if ( ! $onlysize ) @unlink( ENGINE_DIR . '/cache/' . $file );
					else $size += @filesize( ENGINE_DIR . '/cache/' . $file );
				}
			}
			@closedir( $temporary );
		} else {
			if ( is_array( $cachename ) and count( $cachename ) > 0 ) {
				foreach ( $cachename as $file ) {
					if ( ! $onlysize ) @unlink( ENGINE_DIR . '/cache/' . $caches[$file] );
					else $size += @filesize( ENGINE_DIR . '/cache/' . $caches[$file] );
				}
			} else {
				if ( ! $onlysize ) @unlink( ENGINE_DIR . '/cache/' . $caches[$cachename] );
				else $size += @filesize( ENGINE_DIR . '/cache/' . $caches[$cachename] );
			}
		}
		return $onlysize ? $size : true;
	}
	public function configSet( $params, $update = true ) {
		if ( ! is_array( $params ) or count( $params ) <= 0 ) return false;
		$config = array_merge( $this->config, $params );
		$text = "<?php\n\$dlemovie_config = array(\n";
		foreach ( $config as $key => $value ) $text .= "\t'" . $key . "' => '" . addslashes( $value ) . "',\n";
		$text .= ");\n?>";
		$file = @fopen( ENGINE_DIR . '/data/dlemovie.php', 'w+' );
		if ( ! $file ) return false;
		else {
			@fwrite( $file, $text );
			@fclose( $file );
			if ( $update ) $this->config = $config;
		}
		return true;
	}
	public function memberVideosCount( $member ) {
		$count = $this->db->super_query( "SELECT COUNT(*) as count FROM " . PREFIX . "_dm_videos WHERE member = '$member'" );
		return ( int ) $count['count'];
	}
	public function licenseQuery( $hashcode = false ) {
		$hashcode = empty( $hashcode ) ? $this->config['license_key'] : $hashcode;
		if ( empty( $hashcode ) or dle_strlen( $hashcode, $this->dleconfig['charset'] ) != 32 ) return 0;
		$domain = trim( str_replace( 'www.', '', $_SERVER['HTTP_HOST'] ) );
		$length = dle_strlen( $domain, $this->dleconfig['charset'] );
		$domain = ( $domain{$length-1} == '.' ) ? dle_substr( $domain, 0, $length - 1, $this->dleconfig['charset'] ) : $domain;
		$response = @file_get_contents( 'http://server.focusweb.ru/dlemovie/version-check.php?domain=' . $domain . '&license=' . $hashcode . '&version=' . $this->version . '&build=' . $this->build );
		if ( $response === false ) return -1;
		elseif ( $response == 'success' ) return 1;
		return 0;
	}
	public function licenseCheck( ) {
		$this->license = true;
		return true;
	}
	public function commentsAddForm( $video_id ) {
        global $tpl, $user_group, $member_id, $is_logged, $lang, $js_array;
        $config = $this->dleconfig;
        $tpl->load_template( 'addcomments.tpl' );
        if ( $this->dleconfig['allow_comments_wysiwyg'] == 'yes' ) {
            include_once ENGINE_DIR . '/editor/comments.php';
            $bb_code = '';
        } else include_once ENGINE_DIR . '/modules/bbcode.php';
        if ( $user_group[$member_id['user_group']]['captcha'] ) {
            if ( $this->dleconfig['allow_recaptcha'] ) {
                $tpl->set( '[recaptcha]', "" );
                $tpl->set( '[/recaptcha]', "" );
                $tpl->set( '{recaptcha}', '<div id="dle_recaptcha"></div>' );
                $tpl->set_block( "'\\[sec_code\\](.*?)\\[/sec_code\\]'si", "" );
                $tpl->set( '{reg_code}', "" );
            } else {
                $tpl->set( '[sec_code]', "" );
                $tpl->set( '[/sec_code]', "" );
                $path = parse_url( $this->dleconfig['http_home_url'] );
                $tpl->set( '{sec_code}', "<span id=\"dle-captcha\"><img src=\"" . $path['path'] . "engine/modules/antibot.php\" alt=\"${lang['sec_image']}\" border=\"0\" alt=\"\" /><br /><a onclick=\"reload(); return false;\" href=\"#\">{$lang['reload_code']}</a></span>" );
                $tpl->set_block( "'\\[recaptcha\\](.*?)\\[/recaptcha\\]'si", "" );
                $tpl->set( '{recaptcha}', "" );
            }
        } else {
            $tpl->set( '{sec_code}', "" );
            $tpl->set( '{recaptcha}', "" );
            $tpl->set_block( "'\\[recaptcha\\](.*?)\\[/recaptcha\\]'si", "" );
            $tpl->set_block( "'\\[sec_code\\](.*?)\\[/sec_code\\]'si", "" );
        }
        if ( $this->dleconfig['allow_comments_wysiwyg'] == "yes" ) $tpl->set( '{editor}', $wysiwyg );
        else $tpl->set( '{editor}', $bb_code );
        $tpl->set( '{text}', '' );
        $tpl->set( '{title}', $lang['news_addcom'] );
        if ( ! $is_logged ) {
            $tpl->set( '[not-logged]', '' );
            $tpl->set( '[/not-logged]', '' );
        } else $tpl->set_block( "'\\[not-logged\\](.*?)\\[/not-logged\\]'si", "" );
		$tpl->set_block( "'\\[question\\](.*?)\\[/question\\]'si", "" );
        if ( $is_logged ) $hidden = "<input type=\"hidden\" name=\"name\" id=\"name\" value=\"{$member_id['name']}\" /><input type=\"hidden\" name=\"mail\" id=\"mail\" value=\"\" />"; else $hidden = "";
        $tpl->copy_template = "<form  method=\"post\" name=\"dle-comments-form\" id=\"dle-comments-form\" action=\"\">" . $tpl->copy_template . "
        <input type=\"hidden\" name=\"do\" value=\"video\" /><input type=\"hidden\" name=\"act\" value=\"comment\" /><input type=\"hidden\" name=\"video_id\" value=\"{$video_id}\" />{$hidden}</form>";
        if ( ! isset( $path['path'] ) ) $path['path'] = '/';
        $tpl->copy_template .= '
        <script language="javascript" type="text/javascript">
        $(function(){$(\'#dle-comments-form\').submit(function(){DleMovieCommentAdd();return false;});});
        function reload(){var rndval=new Date().getTime();document.getElementById(\'dle-captcha\').innerHTML = \'<img src="' . $path['path'] . 'engine/modules/antibot.php?rndval=\' + rndval + \'" border="0" width="120" height="50" alt="" /><br /><a onclick="reload();return false;" href="#">' . $lang['reload_code'] . '</a>\';}
        </script>';
        if ( $user_group[$member_id['user_group']]['captcha'] AND $config['allow_recaptcha'] ) {
            $tpl->copy_template .= '
            <script type="text/javascript" src="http://www.google.com/recaptcha/api/js/recaptcha_ajax.js"></script>
            <script language="javascript" type="text/javascript">$(function(){Recaptcha.create("' . $config['recaptcha_public_key'] . '","dle_recaptcha",{theme: "' . $config['recaptcha_theme'] . '",lang:  "' . $lang['wysiwyg_language'] . '"});});</script>';
        }
        $tpl->compile( 'dlemovie-addcomment' );
        $tpl->clear( );
        return $tpl->result['dlemovie-addcomment'];
    }
    public function commentsView( $video_id, $title, $category, $only_last = false ) {
        global $tpl, $user_group, $member_id, $is_logged, $lang, $dle_login_hash;
        $page = intval( $_REQUEST['page'] );
        $page = ( $page <= 0 ) ? 1 : $page;
        $limit_topage = $this->config['comments_topage'];
        $limit = ( $page * $limit_topage ) - $limit_topage;
        $tpl->load_template( 'comments.tpl' );
        $tpl->copy_template = "<div id='comment-id-{id}'>" . $tpl->copy_template . "</div>";
        $tpl->template = "<div id='comment-id-{id}'>" . $tpl->template . "</div>";
        if ( strpos( $tpl->copy_template, "[xfvalue_" ) !== false ) $xfound = true; else $xfound = false;
        if ( $xfound ) $xfields = xfieldsload( true );
        if ( $this->config['comments_sort'] == 'desc' and ! $only_last ) $tpl->copy_template = "\n<div id=\"dle-ajax-comments\"></div>\n" . $tpl->copy_template;
        $tpl->copy_template = "<form method=\"post\" action=\"\" name=\"dlemasscomments\" id=\"dlemasscomments\">\n" . $tpl->copy_template;
        if ( ! $only_last ) {
            $sql = $this->db->query( "SELECT " . PREFIX . "_dm_comments.id, video_id, " . PREFIX . "_dm_comments.user_name as name, date, " . PREFIX . "_dm_comments.email as comment_email, text, ip, is_register, " . PREFIX . "_users.email, news_num, comm_num, user_group, reg_date, signature, foto, fullname, land, icq, xfields, dm_comments FROM " . PREFIX . "_dm_comments LEFT JOIN " . PREFIX . "_users ON " . PREFIX . "_dm_comments.user_id=" . PREFIX . "_users.user_id WHERE " . PREFIX . "_dm_comments.video_id = '$video_id' ORDER BY date " . strtoupper( $this->config['comments_sort'] ) . " LIMIT " . $limit . ',' . $limit_topage );
            $count = $this->db->super_query( "SELECT COUNT(*) as count FROM " . PREFIX . "_dm_comments WHERE video_id = '$video_id'" );
            $count = $count['count'];
            $total_pages = ceil( $count / $limit_topage );
        } else {
            $sql = $this->db->query( "SELECT " . PREFIX . "_dm_comments.id, video_id, " . PREFIX . "_dm_comments.user_name as name, date, " . PREFIX . "_dm_comments.email as comment_email, text, ip, is_register, " . PREFIX . "_users.email, news_num, comm_num, user_group, reg_date, signature, foto, fullname, land, icq, xfields, dm_comments FROM " . PREFIX . "_dm_comments LEFT JOIN " . PREFIX . "_users ON " . PREFIX . "_dm_comments.user_id=" . PREFIX . "_users.user_id WHERE " . PREFIX . "_dm_comments.video_id = '$video_id' ORDER BY id DESC LIMIT 0,1" );
            $count = $total_pages = 1;
        }
        while ( $row = $this->db->get_row( $sql ) ) {
            $row['comment_email'] = stripslashes( $row['comment_email'] );
            $row['name'] = stripslashes( $row['name'] );
            if ( ! $row['is_register'] or $row['name'] == '' ) {
                if ( $row['comment_email'] != '' ) $tpl->set( '{author}', "<a href=\"mailto:" . htmlspecialchars( $row['comment_email'], ENT_QUOTES )."\">" . $row['comment_email'] . "</a>" );
                else $tpl->set( '{author}', $row['name'] );
                $tpl->set( '{login}', $row['name'] );
                $tpl->set( '[profile]', '' );
                $tpl->set( '[/profile]', '' );
            } else {
                if ( $this->dleconfig['allow_alt_url'] == "yes" ) {
                    $go_page = $this->dleconfig['http_home_url'] . "user/" . urlencode( $row['name'] ) . "/";                    
                    $tpl->set( '[profile]', "<a href=\"" . $this->dleconfig['http_home_url'] . "user/" . urlencode( $row['name'] ) . "/\">" );
                } else {
                    $go_page = "$PHP_SELF?subaction=userinfo&user=" . urlencode( $row['name'] );
                    $tpl->set( '[profile]', "<a href=\"$PHP_SELF?subaction=userinfo&amp;user=" . urlencode( $row['name'] ) . "\">" );                
                }
                $go_page = "onclick=\"ShowProfile('" . urlencode( $row['name'] ) . "', '" . htmlspecialchars( $go_page ) . "', '" . $user_group[$member_id['user_group']]['admin_editusers'] . "'); return false;\"";
                if ( $this->dleconfig['allow_alt_url'] == "yes" ) $tpl->set( '{author}', "<a {$go_page} href=\"" . $this->dleconfig['http_home_url'] . "user/" . urlencode( $row['name'] ) . "/\">" . $row['name'] . "</a>" );
                else $tpl->set( '{author}', "<a {$go_page} href=\"$PHP_SELF?subaction=userinfo&amp;user=" . urlencode( $row['name'] ) . "\">" . $row['name'] . "</a>" );
                $tpl->set( '{login}', $row['name'] );
                $tpl->set( '[/profile]', "</a>" );
            }
            if ( $is_logged and $member_id['user_group'] == '1' ) $tpl->set( '{ip}', "IP: <a onclick=\"return dropdownmenu(this, event, IPMenu('" . $row['ip'] . "', '" . $lang['ip_info'] . "', '" . $lang['ip_tools'] . "', '" . $lang['ip_ban'] . "'), '190px')\" href=\"https://www.nic.ru/whois/?ip={$row['ip']}\" target=\"_blank\">{$row['ip']}</a>" );
            else $tpl->set( '{ip}', '' );    
            if ( $is_logged AND (($member_id['name'] == $row['name'] AND $row['is_register'] AND $user_group[$member_id['user_group']]['allow_editc']) OR $user_group[$member_id['user_group']]['edit_allc']) ) {
                $tpl->set( '[com-edit]', "<a href=\"javascript:DleMovieCommentEdit('{$row['id']}')\">" );
                $tpl->set( '[/com-edit]', "</a>" );
                $allow_comments_ajax = true;
            } else $tpl->set_block( "'\\[com-edit\\](.*?)\\[/com-edit\\]'si", "" );
            if ( $is_logged AND (($member_id['name'] == $row['name'] and $row['is_register'] and $user_group[$member_id['user_group']]['allow_delc']) or $member_id['user_group'] == '1' or $user_group[$member_id['user_group']]['del_allc']) ) {
                $tpl->set( '[com-del]', "<a href=\"javascript:DleMovieCommentDelete('{$row['id']}','{$dle_login_hash}')\">" );
                $tpl->set( '[/com-del]', "</a>" );
            } else $tpl->set_block( "'\\[com-del\\](.*?)\\[/com-del\\]'si", "" );
            $tpl->set( '{mass-action}', "" );
            if ( ( $user_group[$member_id['user_group']]['allow_addc'] ) and $this->config['comments'] == "yes" ) {
                    $tpl->set( '[fast]', "<a onmouseover=\"dle_copy_quote('" . str_replace( array (" ", "&#039;" ), array ("&nbsp;", "&amp;#039;" ), $row['name'] ) . "');\" href=\"#\" onclick=\"dle_ins('" . str_replace( array (" ", "&#039;" ), array ("&nbsp;", "&amp;#039;" ), $row['name'] ) . "'); return false;\">" );
                    $tpl->set( '[/fast]', "</a>" );
            } else $tpl->set_block( "'\\[fast\\](.*?)\\[/fast\\]'si", "" );
            $tpl->set( '{mail}', $row['email'] );
            $tpl->set( '{id}', $row['id'] );
            if ( date( 'Ymd', $row['date'] ) == date( 'Ymd', $_TIME ) ) $tpl->set( '{date}', $lang['time_heute'] . langdate( ", H:i", $row['date'] ) );
            elseif ( date( 'Ymd', $row['date'] ) == date( 'Ymd', ($_TIME - 86400) ) ) $tpl->set( '{date}', $lang['time_gestern'] . langdate( ", H:i", $row['date'] ) );
            else $tpl->set( '{date}', langdate( $this->dleconfig['timestamp_comment'], $row['date'] ) );
            $tpl->copy_template = preg_replace( "#\{date=(.+?)\}#ie", "langdate('\\1', '{$row['date']}')", $tpl->copy_template );
            $tpl->set( '{news_title}', '' );
            if ( $xfound ) {
                $xfieldsdata = xfieldsdataload( $row['xfields'] );
                foreach ( $xfields as $value ) {
                    $preg_safe_name = preg_quote( $value[0], "'" );
                    if ( $value[5] != 1 or $member_id['user_group'] == 1 or ($is_logged and $row['is_register'] and $member_id['name'] == $row['name']) ) {
                        if ( empty( $xfieldsdata[$value[0]] ) ) $tpl->copy_template = preg_replace( "'\\[xfgiven_{$preg_safe_name}\\](.*?)\\[/xfgiven_{$preg_safe_name}\\]'is", "", $tpl->copy_template );
                        else $tpl->copy_template = preg_replace( "'\\[xfgiven_{$preg_safe_name}\\](.*?)\\[/xfgiven_{$preg_safe_name}\\]'is", "\\1", $tpl->copy_template );
                        $tpl->copy_template = preg_replace( "'\\[xfvalue_{$preg_safe_name}\\]'i", stripslashes( $xfieldsdata[$value[0]] ), $tpl->copy_template );
                    } else {
                        $tpl->copy_template = preg_replace( "'\\[xfgiven_{$preg_safe_name}\\](.*?)\\[/xfgiven_{$preg_safe_name}\\]'is", "", $tpl->copy_template );
                        $tpl->copy_template = preg_replace( "'\\[xfvalue_{$preg_safe_name}\\]'i", "", $tpl->copy_template );
                    }
                }
            }
            $tpl->set( '{comment-id}', $row['id'] );
            if ( $row['foto'] ) $tpl->set( '{foto}', $this->dleconfig['http_home_url'] . "uploads/fotos/" . $row['foto'] );
            else $tpl->set( '{foto}', "{THEME}/images/noavatar.png" );
            if ( $row['is_register'] and $row['icq'] ) $tpl->set( '{icq}', stripslashes( $row['icq'] ) );
            else $tpl->set( '{icq}', '--' );
            if ( $row['is_register'] and $row['land'] ) $tpl->set( '{land}', stripslashes( $row['land'] ) );
            else $tpl->set( '{land}', '--' );
            if ( $row['is_register'] and $row['fullname'] ) $tpl->set( '{fullname}', stripslashes( $row['fullname'] ) );
            else $tpl->set( '{fullname}', '--' );
            if ( $row['is_register'] and $row['reg_date'] ) $tpl->set( '{registration}', langdate( "j.m.Y", $row['reg_date'] ) );
            else $tpl->set( '{registration}', '--' );
            if ( $row['is_register'] and $row['signature'] and $user_group[$row['user_group']]['allow_signature'] ) {
                $tpl->set_block( "'\\[signature\\](.*?)\\[/signature\\]'si", "\\1" );
                $tpl->set( '{signature}', stripslashes( $row['signature'] ) );
            } else $tpl->set_block( "'\\[signature\\](.*?)\\[/signature\\]'si", "" );
            $tpl->set_block( "'\\[complaint\\](.*?)\\[/complaint\\]'si", "" );
            if ( ! $row['user_group'] ) $row['user_group'] = 5;
            $tpl->set( '{group-icon}', "" );
            $tpl->set( '{group-name}', $user_group[$row['user_group']]['group_prefix'].$user_group[$row['user_group']]['group_name'].$user_group[$row['user_group']]['group_suffix'] );
            $tpl->set( '{news-num}', intval( $row['news_num'] ) );
            $tpl->set( '{comm-num}', intval( $row['comm_num'] ) );
            $tpl->set( '{total-comm-num}', intval( $row['comm_num'] ) + intval( $row['dm_comments'] ) );
            $tpl->set( '{dlemovie-comm-num}', intval( $row['dm_comments'] ) );
            $row['text'] = preg_replace( "#\[hide\](.+?)\[/hide\]#is", "<div class=\"quote\">" . $lang['news_regus'] . "</div>", $row['text'] );
            $tpl->set( '{comment}', "<div id='comm-id-" . $row['id'] . "'>" . stripslashes( $row['text'] ) . "</div>" );
            $tpl->compile( 'comments' );
        }
        if ( $this->config['comments_sort'] == 'asc' and ! $only_last ) $tpl->result['comments'] .= "\n<div id=\"dle-ajax-comments\"></div>\n";
        $tpl->result['comments'] .= "</form>\n";

        if ( $count > $limit_topage ) {
        	$title = totranslit( ( dle_strlen( $title, $this->dleconfig['charset'] ) > 50 ) ? dle_substr( $title, 0, 50, $this->dleconfig['charset'] ) : $title );
        	if ( $this->config['categories'] == 'yes' and $category > 0 ) {
        		$category = $this->category[$category]['name'];
        		$linkformat = $this->parseUrl( '?do=video&act=view&video_id=' . $video_id . '&page={number}', 'video/' . $category . '/' . $video_id . '-' . $title . '/page-{number}.html' );
        	} else $linkformat = $this->parseUrl( '?do=video&act=view&video_id=' . $video_id . '&page={number}', 'video/all/' . $video_id . '-' . $title . '/page-{number}.html' );
            $tpl->load_template( 'navigation.tpl' );
            if ( $page > 1 ) {
                $tpl->set( '[prev-link]', '<a href="' . str_replace( '{number}', $page - 1, $linkformat ) . '">' );
                $tpl->set( '[/prev-link]', '</a> ' );
            } else {
                $tpl->set( '[prev-link]', '<span>' );
                $tpl->set( '[/prev-link]', '</span>' );
            }
            $enpages_count = $total_pages;
            $pages = '';
            $cstart = $page;
            if ( $enpages_count <= 10 ) {
                for ( $j = 1; $j <= $enpages_count; $j ++ ) {
                    if ( $j != $cstart ) $pages .= "<a href=\"" . str_replace( '{number}', $j, $linkformat ) . "\">$j</a> ";
                    else $pages .= "<span>$j</span> ";
                }
            } else {
                $start = 1;
                $end = 10;
                $nav = '<span>...</span>';
                if ( $cstart > 0 ) {
                    if ( $cstart > 6 ) {
                        $start = $cstart - 4;
                        $end = $start + 8;
                        if ( $end >= $enpages_count ) {
                            $start = $enpages_count - 9;
                            $end = $enpages_count - 1;
                            $nav = '';
                        } else $nav = '<span>...</span>';
                    }
                }
                if ( $start >= 2 ) $pages .= "<a href=\"" . str_replace( '{number}', 1, $linkformat ) . "\">1</a> <span>...</span> ";
                for ( $j = $start; $j <= $end; $j ++ ) {
                    if ( $j != $cstart ) $pages .= "<a href=\"" . str_replace( '{number}', $j, $linkformat ) . "\">$j</a> ";
                    else $pages .= "<span>$j</span> ";
                }
                if ( $cstart != $enpages_count ) $pages .= "$nav <a href=\"" . str_replace( '{number}', $enpages_count, $linkformat ) . "\">$enpages_count</a> ";
                else $pages .= "<span>$enpages_count</span> ";
            }
            $tpl->set( '{pages}', $pages );
            if ( $page != $total_pages ) {
                $tpl->set( '[next-link]', ' <a href="' . str_replace( '{number}', $page + 1, $linkformat ). '">' );
                $tpl->set( '[/next-link]', '</a>' );
            } else {
                $tpl->set( '[next-link]', '<span>' );
                $tpl->set( '[/next-link]', '</span>' );
            }
            $tpl->compile( 'dletrack-comment-navigation' );
            $tpl->result['comments'] .= '<br />' . $tpl->result['dletrack-comment-navigation'];
        }

        $this->db->free( $sql );
        return $tpl->result['comments'];
    }
    public function openGraphProtocol( $url, $title, $image, $description = '' ) {
    	if ( dle_strlen( $title, $config['charset'] ) > 40 ) $title = dle_substr( $title, 0, 40, $config['charset'] ) . ' ...';
    	if ( dle_strlen( $description, $config['charset'] ) > 255 ) $description = dle_substr( $description, 0, 255, $config['charset'] );
    	return '
				<meta property="og:url" content="' . $url . '" />
				<meta property="og:title" content="' . htmlspecialchars( $title ) . '" />
				' . ( ! empty( $description ) ? '<meta property="og:description" content="' . htmlspecialchars( $description ) . '" />' : '' ) . '
				<meta property="og:type" content="video" />
				<meta property="og:image" content="' . $image . '" />
				<meta property="og:image:width" content="' . $this->screenw . '" />
				<meta property="og:image:height" content="' . $this->screenh . '" />
				<meta property="og:video" content="' . $url . '" />
				<meta property="og:video:type" content="application/x-shockwave-flash" />
				<meta property="og:video:width" content="480" />
				<meta property="og:video:height" content="360" />' . "\n";
    }
}
}
?>